--==========================================================================================================================
-- UNITS
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,								Kind)
VALUES	('UNIT_JFD_CHAR_B1',				'KIND_UNIT');		
--------------------------------------------------------------------------------------------------------------------------
-- Units
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Units	
		(UnitType,							BaseMoves, Cost, AdvisorType, BaseSightRange, ZoneOfControl, Domain, FormationClass, Name,							Description,						MandatoryObsoleteTech, PurchaseYield, PromotionClass, Maintenance, Combat, PrereqTech, StrategicResource, TraitType)
SELECT  'UNIT_JFD_CHAR_B1',					BaseMoves, Cost, AdvisorType, BaseSightRange, ZoneOfControl, Domain, FormationClass, 'LOC_UNIT_JFD_CHAR_B1_NAME',	'LOC_UNIT_JFD_CHAR_B1_DESCRIPTION',	MandatoryObsoleteTech, PurchaseYield, PromotionClass, Maintenance, Combat, PrereqTech, StrategicResource, 'TRAIT_LEADER_UNIT_JFD_CHAR_B1'		
FROM Units WHERE UnitType = 'UNIT_TANK';
--------------------------------------------------------------------------------------------------------------------------
-- UnitReplaces
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO UnitReplaces	
		(CivUniqueUnitType,					ReplacesUnitType)
VALUES	('UNIT_JFD_CHAR_B1',				'UNIT_TANK');	
--------------------------------------------------------------------------------------------------------------------------
-- UnitUpgrades
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO UnitUpgrades	
		(Unit,								UpgradeUnit)
SELECT  'UNIT_JFD_CHAR_B1',					UpgradeUnit
FROM UnitUpgrades WHERE Unit = 'UNIT_TANK'; 	
--------------------------------------------------------------------------------------------------------------------------
-- UnitAIInfos
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO UnitAIInfos	
		(UnitType,							AiType)
SELECT  'UNIT_JFD_CHAR_B1',					AiType
FROM UnitAIInfos WHERE UnitType = 'UNIT_TANK'; 
--------------------------------------------------------------------------------------------------------------------------
-- Tags
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Tags	
		(Tag,								Vocabulary)
VALUES	('CLASS_JFD_CHAR_B1',				'ABILITY_CLASS'),
		('CLASS_JFD_FREE_FRANCE_GENERAL',	'ABILITY_CLASS');	
--------------------------------------------------------------------------------------------------------------------------
-- TypeTags
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO TypeTags	
		(Type,								Tag)
SELECT  'UNIT_JFD_CHAR_B1',					Tag
FROM TypeTags WHERE Type = 'UNIT_TANK';

INSERT INTO TypeTags	
		(Type,								Tag)
VALUES	('UNIT_JFD_CHAR_B1',				'CLASS_JFD_CHAR_B1'),
		('UNIT_GREAT_GENERAL',				'CLASS_JFD_FREE_FRANCE_GENERAL');
--==========================================================================================================================
-- UNITS: ABILITIES
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,												Kind)
VALUES	('ABILITY_JFD_CHAR_B1',								'KIND_ABILITY'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES',			'KIND_ABILITY'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',			'KIND_ABILITY');
--------------------------------------------------------------------------------------------------------------------------
-- TypeTags
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO TypeTags
		(Type, 												Tag)
VALUES  ('ABILITY_JFD_CHAR_B1',								'CLASS_JFD_CHAR_B1'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES',  			'CLASS_JFD_FREE_FRANCE_GENERAL'),		
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_RECON'),		
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_MELEE'),	
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_RANGED'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_SIEGE'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_HEAVY_CHARIOT'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_LIGHT_CHARIOT'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_HEAVY_CAVALRY'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_RANGED_CAVALRY'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_LIGHT_CAVALRY'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',  		'CLASS_ANTI_CAVALRY');
--------------------------------------------------------------------------------------------------------------------------
-- UnitAbilities
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO UnitAbilities	
		(UnitAbilityType,									Name,															Inactive,	Description)
VALUES	('ABILITY_JFD_CHAR_B1',								'LOC_ABILITY_JFD_CHAR_B1_NAME',									0,			'LOC_ABILITY_JFD_CHAR_B1_DESCRIPTION'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES',			'LOC_ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES_NAME',				1,			'LOC_ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES_DESCRIPTION'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',			'LOC_ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS_NAME',				1,			'LOC_ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS_DESCRIPTION');	
--------------------------------------------------------------------------------------------------------------------------
-- UnitAbilityModifiers
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO UnitAbilityModifiers	
		(UnitAbilityType,									ModifierId)
VALUES	('ABILITY_JFD_CHAR_B1',								'JFD_CHAR_B1_DEFENDING_BONUS'),
		('ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES',			'JFD_FREE_FRANCE_GENERAL_MOVES'),	
		('ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS',			'JFD_FREE_FRANCE_GENERAL_POINTS_FROM_KILLS');	
--------------------------------------------------------------------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Modifiers	
		(ModifierId,										ModifierType,													SubjectRequirementSetId)
VALUES	('JFD_CHAR_B1_DEFENDING_BONUS',						'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',							'JFD_CHAR_B1_IS_DEFENDER_REQ_SET'),
		('JFD_FREE_FRANCE_GENERAL_MOVES',					'MODIFIER_PLAYER_UNIT_ADJUST_MOVEMENT',							null),
		('JFD_FREE_FRANCE_GENERAL_POINTS_FROM_KILLS',		'MODIFIER_PLAYER_UNIT_ADJUST_GREAT_PEOPLE_POINTS_PER_KILL',		'JFD_FREE_FRANCE_UNIT_IN_OWN_PLOT_REQ_SET');
--------------------------------------------------------------------------------------------------------------------------
-- ModifierStrings
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierStrings
		(ModifierId,										Context,														Text)
VALUES	('JFD_CHAR_B1_DEFENDING_BONUS',						'Preview',														'JFD_CHAR_B1_COMBAT_BONUS_DESC');	
--------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,															Value)
VALUES	('JFD_CHAR_B1_DEFENDING_BONUS',						'Amount',														7),
		('JFD_FREE_FRANCE_GENERAL_MOVES',					'Amount',														2),
		('JFD_FREE_FRANCE_GENERAL_POINTS_FROM_KILLS',		'GreatPersonClassType',											'GREAT_PERSON_CLASS_GENERAL'),
		('JFD_FREE_FRANCE_GENERAL_POINTS_FROM_KILLS',		'Amount',														5);	
--------------------------------------------------------------------------------------------------------------------------
-- RequirementSets
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,									RequirementSetType)
VALUES	('JFD_CHAR_B1_IS_DEFENDER_REQ_SET',					'REQUIREMENTSET_TEST_ALL'),
		('JFD_FREE_FRANCE_UNIT_IN_OWN_PLOT_REQ_SET',		'REQUIREMENTSET_TEST_ALL');
--------------------------------------------------------------------------------------------------------------------------
-- RequirementSetRequirements
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,									RequirementId)
VALUES	('JFD_CHAR_B1_IS_DEFENDER_REQ_SET',					'PLAYER_IS_DEFENDER_REQUIREMENTS'),
		('JFD_FREE_FRANCE_UNIT_IN_OWN_PLOT_REQ_SET',		'UNIT_IN_OWNER_TERRITORY_REQUIREMENT');
--==========================================================================================================================
-- UNITS: TRAITS
--==========================================================================================================================	
-- Types			
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,								Kind)
VALUES	('TRAIT_LEADER_UNIT_JFD_CHAR_B1',	'KIND_TRAIT');
--------------------------------------------------------------------------------------------------------------------------
-- Traits
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Traits				
		(TraitType,							Name,												Description)
VALUES	('TRAIT_LEADER_UNIT_JFD_CHAR_B1',	'LOC_UNIT_JFD_CHAR_B1_NAME',						null);	
--==========================================================================================================================
-- LEADERS
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,								Kind)
VALUES	('LEADER_JFD_DE_GAULLE',			'KIND_LEADER');	
--------------------------------------------------------------------------------------------------------------------------
-- Leaders
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Leaders	
		(LeaderType,						Name,												InheritFrom,			SceneLayers)
VALUES	('LEADER_JFD_DE_GAULLE',			'LOC_LEADER_JFD_DE_GAULLE_NAME',					'LEADER_DEFAULT',		4);	
--------------------------------------------------------------------------------------------------------------------------
-- LeaderQuotes
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO LeaderQuotes	
		(LeaderType,						Quote)
VALUES	('LEADER_JFD_DE_GAULLE',			'LOC_PEDIA_LEADERS_PAGE_LEADER_JFD_DE_GAULLE_QUOTE');	
--------------------------------------------------------------------------------------------------------------------------
-- HistoricalAgendas
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO HistoricalAgendas	
		(LeaderType,						AgendaType)
VALUES	('LEADER_JFD_DE_GAULLE',			'AGENDA_JFD_GRANDEUR');	
--------------------------------------------------------------------------------------------------------------------------
-- LeaderTraits
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO LeaderTraits	
		(LeaderType,						TraitType)
VALUES	('LEADER_JFD_DE_GAULLE',			'TRAIT_LEADER_JFD_FREE_FRANCE'),
		('LEADER_JFD_DE_GAULLE',			'TRAIT_LEADER_UNIT_JFD_CHAR_B1');	
--------------------------------------------------------------------------------------------------------------------------
-- FavoredReligions
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO FavoredReligions	
		(LeaderType,						ReligionType)
VALUES	('LEADER_JFD_DE_GAULLE',			'RELIGION_CATHOLICISM');	

CREATE TRIGGER JFD_DeGaulle_FavoredReligions 
AFTER INSERT ON Religions WHEN 'RELIGION_CATHOLICISM' = NEW.ReligionType 
BEGIN INSERT INTO FavoredReligions 
		(LeaderType, 		 		ReligionType) 
VALUES 	('LEADER_JFD_DE_GAULLE', 	'RELIGION_CATHOLICISM'); 
END;
--==========================================================================================================================
-- LEADER: AI
--==========================================================================================================================
-- AiListTypes
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO AiListTypes	
		(ListType)
VALUES	('JFD_DeGaulleWonders'),
		('JFD_DeGaulleCivics'),
		('JFD_DeGaulleTechs');
--------------------------------------------------------------------------------------------------------------------------
-- AiLists
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO AiLists	
		(ListType,						LeaderType,							System)
VALUES	('JFD_DeGaulleWonders',			'TRAIT_LEADER_JFD_FREE_FRANCE',		'Buildings'),
		('JFD_DeGaulleCivics',			'TRAIT_LEADER_JFD_FREE_FRANCE',		'Civics'),
		('JFD_DeGaulleTechs',			'TRAIT_LEADER_JFD_FREE_FRANCE',		'Technologies'),
		('WithShieldDiplomacy',			'TRAIT_LEADER_JFD_FREE_FRANCE',		'DiplomaticActions');	
--------------------------------------------------------------------------------------------------------------------------		
-- AiFavoredItems
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO AiFavoredItems	
		(ListType,						Item)
VALUES	('JFD_DeGaulleWonders',			'BUILDING_ALHAMBRA'),
		('JFD_DeGaulleWonders',			'BUILDING_RUHR_VALLEY'), 
		('JFD_DeGaulleWonders',			'BUILDING_TERRACOTTA_ARMY'), 
		('JFD_DeGaulleCivics',			'CIVIC_DIPLOMATIC_SERVICE'), 
		('JFD_DeGaulleTechs',			'TECH_MILITARY_SCIENCE');
--==========================================================================================================================
-- LEADER: AGENDAS
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,								Kind)
VALUES	('TRAIT_AGENDA_JFD_GRANDEUR',		'KIND_TRAIT');			
--------------------------------------------------------------------------------------------------------------------------			
-- Agendas			
--------------------------------------------------------------------------------------------------------------------------				
INSERT INTO Agendas				
		(AgendaType,						Name,									Description)
VALUES	('AGENDA_JFD_GRANDEUR',				'LOC_AGENDA_JFD_GRANDEUR_NAME',			'LOC_AGENDA_JFD_GRANDEUR_DESCRIPTION');	
--------------------------------------------------------------------------------------------------------------------------			
-- Traits			
--------------------------------------------------------------------------------------------------------------------------				
INSERT INTO Traits				
		(TraitType,							Name,									Description)
VALUES	('TRAIT_AGENDA_JFD_GRANDEUR',		'LOC_PLACEHOLDER',						'LOC_PLACEHOLDER');	
--------------------------------------------------------------------------------------------------------------------------			
-- AgendaTraits			
--------------------------------------------------------------------------------------------------------------------------				
INSERT INTO AgendaTraits				
		(AgendaType,						TraitType)
VALUES	('AGENDA_JFD_GRANDEUR',				'TRAIT_AGENDA_JFD_GRANDEUR');	
--------------------------------------------------------------------------------------------------------------------------		
-- TraitModifiers		
--------------------------------------------------------------------------------------------------------------------------			
INSERT INTO TraitModifiers			
		(TraitType,											ModifierId)
VALUES	('TRAIT_AGENDA_JFD_GRANDEUR',						'JFD_GRANDEUR_MODIFIER_CITY_LIBERATED'),
		('TRAIT_AGENDA_JFD_GRANDEUR',						'JFD_GRANDEUR_MODIFIER_SURPRISE_WAR');	
----------------------------------------------------------------------------------------------------------------------------
-- Modifiers
----------------------------------------------------------------------------------------------------------------------------
INSERT INTO Modifiers	
		(ModifierId,										ModifierType,										SubjectRequirementSetId)
VALUES	('JFD_GRANDEUR_MODIFIER_CITY_LIBERATED',			'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',		'PLAYER_CITY_LIBERATED'),
		('JFD_GRANDEUR_MODIFIER_SURPRISE_WAR',				'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',		'PLAYER_DECLARES_SURPRISE_WAR');
----------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
----------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,									Value)
VALUES	('JFD_GRANDEUR_MODIFIER_CITY_LIBERATED',			'InitialValue',							10),
		('JFD_GRANDEUR_MODIFIER_CITY_LIBERATED',			'ReductionTurns',						20),
		('JFD_GRANDEUR_MODIFIER_CITY_LIBERATED',			'ReductionValue',						-1),
		('JFD_GRANDEUR_MODIFIER_CITY_LIBERATED',			'StatementKey',							'LOC_DIPLO_KUDO_LEADER_JFD_DE_GAULLE_REASON_CITY_LIBERATED'),
		('JFD_GRANDEUR_MODIFIER_CITY_LIBERATED',			'SimpleModifierDescription',			'LOC_DIPLO_MODIFIER_AGENDA_JFD_GRANDEUR_CITY_LIBERATED'),
		('JFD_GRANDEUR_MODIFIER_SURPRISE_WAR',				'InitialValue',							-10),
		('JFD_GRANDEUR_MODIFIER_SURPRISE_WAR',				'ReductionTurns',						10),
		('JFD_GRANDEUR_MODIFIER_SURPRISE_WAR',				'ReductionValue',						-1),
		('JFD_GRANDEUR_MODIFIER_SURPRISE_WAR',				'StatementKey',							'LOC_DIPLO_WARNING_LEADER_JFD_DE_GAULLE_REASON_SURPRISE_WAR'),
		('JFD_GRANDEUR_MODIFIER_SURPRISE_WAR',				'SimpleModifierDescription',			'LOC_DIPLO_MODIFIER_AGENDA_JFD_GRANDEUR_SURPRISE_WAR');
--==========================================================================================================================
-- LEADERS: COLOURS
--==========================================================================================================================
-- PlayerColors
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO PlayerColors	
		(Type,							Usage,				PrimaryColor, 									SecondaryColor,										TextColor)
VALUES	('LEADER_JFD_DE_GAULLE',		'Unique',			'COLOR_PLAYER_JFD_FRANCE_DE_GAULLE_PRIMARY',	'COLOR_PLAYER_JFD_FRANCE_DE_GAULLE_SECONDARY',		'COLOR_PLAYER_WHITE_TEXT');	
--------------------------------------------------------------------------------------------------------------------------
-- Colors
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Colors 
		(Type, 												Red, 	Green, 	Blue, 	Alpha)
VALUES	('COLOR_PLAYER_JFD_FRANCE_DE_GAULLE_PRIMARY', 		0.219,	0.270,	0.333,	1),
		('COLOR_PLAYER_JFD_FRANCE_DE_GAULLE_SECONDARY', 	0.8,	0.266,	0.003,	1);
--==========================================================================================================================
-- LEADERS: LOADING INFO
--==========================================================================================================================
-- LoadingInfo
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO LoadingInfo	
		(LeaderType,					ForegroundImage,						PlayDawnOfManAudio)
VALUES	('LEADER_JFD_DE_GAULLE',		'LEADER_JFD_DE_GAULLE_NEUTRAL',			0);	
--==========================================================================================================================
-- LEADERS: TRAITS
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Types	
		(Type,												Kind)
VALUES	('TRAIT_LEADER_JFD_FREE_FRANCE',					'KIND_TRAIT');	
--------------------------------------------------------------------------------------------------------------------------			
-- Traits			
--------------------------------------------------------------------------------------------------------------------------				
INSERT INTO Traits				
		(TraitType,											Name,												Description)
VALUES	('TRAIT_LEADER_JFD_FREE_FRANCE',					'LOC_TRAIT_LEADER_JFD_FREE_FRANCE_NAME',			'LOC_TRAIT_LEADER_JFD_FREE_FRANCE_DESCRIPTION');	
--------------------------------------------------------------------------------------------------------------------------		
-- TraitModifiers		
--------------------------------------------------------------------------------------------------------------------------			
INSERT INTO TraitModifiers			
		(TraitType,											ModifierId)
VALUES	('TRAIT_LEADER_JFD_FREE_FRANCE',					'JFD_FREE_FRANCE_GREAT_GENERAL_KILLS'),					
		('TRAIT_LEADER_JFD_FREE_FRANCE',					'JFD_FREE_FRANCE_GREAT_GENERAL_MOVES');						
--------------------------------------------------------------------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Modifiers	
		(ModifierId,										ModifierType,										Permanent,	SubjectRequirementSetId)
VALUES	('JFD_FREE_FRANCE_GREAT_GENERAL_KILLS',				'MODIFIER_PLAYER_UNITS_GRANT_ABILITY',				1,			null),
		('JFD_FREE_FRANCE_GREAT_GENERAL_MOVES',				'MODIFIER_PLAYER_UNITS_GRANT_ABILITY',				1,			null);
--------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,												Value)
VALUES	('JFD_FREE_FRANCE_GREAT_GENERAL_KILLS',				'AbilityType',										'ABILITY_JFD_FREE_FRANCE_GENERAL_POINTS'),
		('JFD_FREE_FRANCE_GREAT_GENERAL_MOVES',				'AbilityType',										'ABILITY_JFD_FREE_FRANCE_GENERAL_MOVES');
--==========================================================================================================================
-- CIVILIZATIONS
--==========================================================================================================================
-- CivilizationLeaders
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO CivilizationLeaders	
		(CivilizationType,			LeaderType,					CapitalName)
VALUES	('CIVILIZATION_FRANCE',		'LEADER_JFD_DE_GAULLE',		'LOC_CITY_NAME_PARIS');
--==========================================================================================================================
--==========================================================================================================================